import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class Selection extends DrawObject
{
	// DrawObject abilities:
	@Override
	public boolean CanBeDeletedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeExcitedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeMovedByUser()
	{
		return false;
	};

	@Override
	public boolean CanBeSelectedByUser()
	{
		return false;
	}
	// end of DrawObject abilities

	public Selection(Point TopLeftPos)
	{
		SetPosNoAlignOnGrid(TopLeftPos);
		SetSize(new Point(10, 10));
	};

	@Override
	public void Draw(Graphics g)
	{
		// draw single rectangular frame
		SetColor(g, Color.MAGENTA);
		NegativeDrawRect(g, Pos.x, Pos.y, Size.x, Size.y);
	}

	public Point GetEndPoint() // "flipped" selection is also supported, needn't to be the bottom right pos
	{
		return new Point(Pos.x + Size.x, Pos.y + Size.y);
	}

	public void SetEndPoint(Point BottomRightPos) // "flipped" selection is also supported, needn't to be the bottom right pos
	{
		Size.x = BottomRightPos.x - Pos.x;
		Size.y = BottomRightPos.y - Pos.y;
	}
}
